/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ipv6;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.BadValue;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Label;

public class IPv4v6addressRO
extends Label
implements JDMInput {
    protected boolean ignoreValue;
    protected boolean hasErrorValue;

    public IPv4v6addressRO() {
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public void setText(String string) {
        super.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
        this.invalidate();
    }

    public Object getValue() {
        return new String(this.getText());
    }

    public String toString() {
        return new String(this.getText());
    }

    public void setValue(String string) {
        boolean bl = true;
        int n = 0;
        if (string == null) {
            bl = false;
        } else {
            n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!Character.isDigit(c) && c != '.') {
                    bl = false;
                }
                ++n2;
            }
        }
        if (bl) {
            this.setText(string);
            return;
        }
        this.setValue(new BadValue());
    }

    public void setValue(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            if (octetString.value.length == 4) {
                this.setText(this.toIPv4(octetString.value));
            } else if (octetString.value.length == 16) {
                this.setText(this.toIPv6(octetString.toString(), octetString.value));
            } else {
                this.setText(octetString.toString());
            }
            this.ignoreValue = false;
            this.hasErrorValue = false;
            return;
        }
        if (object instanceof IPAddress) {
            this.setValue(object.toString());
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            this.setText(specialValue.toString());
            this.ignoreValue = object instanceof NotSupported;
            this.hasErrorValue = true;
        }
    }

    private String toIPv4(byte[] byArray) {
        IPAddress iPAddress = new IPAddress(byArray, 0);
        return iPAddress.getIpAddress();
    }

    private String toIPv6(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string.length() != 32) {
            return string;
        }
        if (string.equals("00000000000000000000000000000000")) {
            return "::";
        }
        if (string.equals("00000000000000000000000000000001")) {
            return "::1";
        }
        int n2 = 0;
        while (n2 < 32) {
            String string2 = string.substring(n2, n2 + 4);
            if (string2.equals("0000")) {
                ++n;
                if (!bl2) {
                    stringBuffer.append("0");
                }
                if (n == 6 && n2 == 20) {
                    bl = true;
                }
            } else {
                if (n == 1) {
                    stringBuffer.append("0:");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                    bl2 = false;
                    if (bl3) {
                        stringBuffer.append(":");
                    }
                }
                string2 = this.zeroStrip(string2);
                stringBuffer.append(string2);
                if (n == 5 && n2 == 20 && (string2.equals("ffff") || string2.equals("FFFF"))) {
                    bl = true;
                }
                n = 0;
                bl3 = false;
            }
            if (n2 == 28) {
                if (n == 1) {
                    stringBuffer.append("0");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                }
                if (n == 8) {
                    stringBuffer.append(":");
                }
            } else if (n == 0) {
                stringBuffer.append(":");
            }
            if (bl) {
                if (n > 4) {
                    stringBuffer.append(":");
                }
                if (n == 6) {
                    stringBuffer.append(":");
                }
                IPAddress iPAddress = new IPAddress(byArray, 12);
                stringBuffer.append(iPAddress.getIpAddress());
                break;
            }
            n2 += 4;
        }
        return stringBuffer.toString().toUpperCase();
    }

    private String zeroStrip(String string) {
        String string2 = string;
        if (string2 != null && string2.trim() != null) {
            int n = 0;
            while (n < string.length()) {
                if (string2.startsWith("0")) {
                    string2 = string2.substring(1);
                }
                ++n;
            }
        }
        return string2;
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

